IF EXISTS(  SELECT * FROM sys.views WHERE object_id=OBJECT_ID(N'[dbo].[V_RC_CLI_TENTACLE]') )
    DROP VIEW [dbo].[V_RC_CLI_TENTACLE];
GO

CREATE VIEW [dbo].[V_RC_CLI_TENTACLE]
AS
SELECT
     rc_Cli.bairro
    ,rc_Cli.cd_cid
    ,rc_Cli.cd_cli
    ,isnull(V_RC_CLI_CONVENIADOS.cd_conv,0) AS cd_conv
    ,rc_Cli.cd_emp
    ,rc_Cli.cd_filial
    ,rc_Cli.cep
    ,rc_Cli.cgc_cpf
    ,isnull(rc_Cli.cons_final,0) cons_final
    ,rc_Cli.end_cli
    ,rc_Cli.nm_fant
    ,rc_Cli.rz_cli
    ,rc_Cli.sts_cli
    ,rc_Cli.sts_cred
    ,isnull(rc_Cli.tp_cad,0) tp_cad
    ,isnull(rc_Cli.tp_cons_final,0) tp_cons_final
    ,isnull(rc_Cli.vlr_cred,0) vlr_cred
    ,isnull(rc_Cli.vlr_deb,0) vlr_deb
    ,rc_Cli.matricula
    ,rc_Cli.sexo_cli
    ,rc_Cli.esp_cli
    ,isnull(rc_Cli.rot_conv_ext,0) rot_conv_ext
    ,rc_Cli.pessoa
    ,isnull(rc_Cli.ddd_tel,'') AS ddd_tel
    ,rc_Cli.tel
    ,COALESCE(rc_Cli.senha,RC_CLI_FIDELI_CARTAO.senha,'') AS senha
    ,rc_Cli.cd_plano_venda
    ,isnull(RC_CLI_FIDELI_CARTAO.nr_cartao,0) AS nr_cartao
    ,rc_Cli.obs
    ,isnull(rc_Cli.qtde_pontos,0) AS qtde_pontos
    ,isnull(V_RC_CLI_CONVENIADOS.perc_rec_max_conv,0) AS perc_rec_max_conv
    ,isnull(V_RC_CLI_CONVENIADOS.perc_rec_min_conv,0) AS perc_rec_min_conv
    ,isnull(rc_Cli.exige_senha_compra,0) AS exige_senha_compra
    ,isnull(rc_Cli.flag_cliente_crediario,0) AS flag_cliente_crediario
    ,rc_Cli.flag_cli_fidel
    ,isnull(rc_Cli.cd_rede_pbm_scope,0) AS cd_rede_pbm_scope
    ,ISNULL(DBO.RC_CLI.CD_PRECO_CLAS_CLIENTE,0) AS CD_PRECO_CLAS_CLIENTE
    ,rc_Cli.rg
    ,rc_Cli.rg_org_exp
    ,ISNULL(rc_Cli.flag_nao_aparecer_estatistica_compra,0) AS flag_nao_aparecer_estatistica_compra
    ,rc_Cli.complemento 
	,isnull(rc_Cli.dt_nasc, '1900-01-01') dt_nasc
    ,isnull(rc_Cli.numero,0) AS numero
    ,isnull(rc_Cli.data_nasc, '1900-01-01') data_nasc
    ,rc_Cli.dt_cad
    ,rc_Cli.ponto_ref
    ,ISNULL(rc_Cli.flag_n_troca_pontos,0) AS flag_n_troca_pontos
    ,isnull(rc_Cli.sts_end,0) AS sts_end
    ,rc_Cli.cd_cond_pgto
    ,isnull(rc_Cli.complemento_residencial,'') AS complemento_residencial
    ,rc_Cli.email
    ,rc_Cli.telefone1
    ,rc_Cli.dd1
    ,ISNULL(DBO.RC_CLI.NM_MAE,'') AS NM_MAE
    ,ISNULL(DBO.RC_CLI.NM_PAI,'') AS NM_PAI
    ,rc_Cli.cd_usu
    ,rc_Cli.cd_fun
    ,rc_Cli.cd_tp_cli
    ,isnull(rc_Cli.dt_ult_alt,getdate()) dt_ult_alt
    ,isnull(rc_Cli.cd_usu_alt,0) AS cd_usu_alt
    ,rc_Cli.insc_est
    ,rc_Cli.insc_muni
    ,isnull(rc_Cli.cd_cid_logra,0) AS cd_cid_logra
    ,rc_Cli.cd_regi
    ,rc_Cli.nr_cartao_antigo
    ,ISNULL(RC_CLI.FLAG_ISENTO_IMPOSTO,0) AS FLAG_ISENTO_IMPOSTO
	,ISNULL(RC_CLI.FLAG_DEPENDENTE_COMP_LIMITE_TITULAR,0) AS FLAG_DEPENDENTE_COMP_LIMITE_TITULAR
FROM
	DBO.RC_CLI
	LEFT OUTER JOIN DBO.V_RC_CLI_CONVENIADOS ON DBO.RC_CLI.CD_EMP=DBO.V_RC_CLI_CONVENIADOS.CD_EMP
										AND DBO.RC_CLI.CD_CLI=DBO.V_RC_CLI_CONVENIADOS.CD_CLI
	LEFT OUTER JOIN DBO.RC_CLI_CREDIARIO ON DBO.RC_CLI.CD_EMP=DBO.RC_CLI_CREDIARIO.CD_EMP
									AND DBO.RC_CLI.CD_CLI=DBO.RC_CLI_CREDIARIO.CD_CLI
	LEFT OUTER JOIN DBO.RC_CLI_FIDELI_CARTAO ON DBO.RC_CLI.CD_EMP=DBO.RC_CLI_FIDELI_CARTAO.CD_EMP
										AND DBO.RC_CLI.CD_CLI=DBO.RC_CLI_FIDELI_CARTAO.CD_CLI
	WHERE rc_Cli.cd_emp=1;
GO
